<?php

namespace Database\Seeders;

use App\Enums\WebSettings;
use App\Models\WebSetting;
use Illuminate\Database\Seeder;


class WebSettingTableSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $adminUrl = env('APP_URL');
        foreach (WebSettings::cases() as $setting) {
            if($setting->value === 'header'){
                WebSetting::create([
                    'key' => $setting->value,
                    'value' => json_encode([
                        'logo' =>'assets/images/logo/logo-white.svg',
                    ])
                ]);
            }
            elseif($setting->value === 'banner'){
                WebSetting::create([
                    'key' => $setting->value,
                    'value' => json_encode([
                        'image_group' => [
                            [
                                'img' =>'assets/images/user/avatar-01.png',
                            ],
                            [
                                'img' =>'assets/images/user/avatar-02.png',
                            ],
                            [
                                'img' =>'assets/images/user/avatar-03.png',
                            ],

                        ],
                        'ratings' => 4.5,
                        'reviews' => '10k+ Reviews',
                        'title' => 'The Only App <br /> You Need to Get <br /> Around Town Effortlessly',
                        'description' => 'Fast, affordable, and secure transportation with real-time tracking and multiple ride options — powered by our locally trusted platform.',
                        'app_store' => [
                            [
                                'link' => '#',
                                'thumb' =>'assets/images/app-store-icon.png',
                            ],
                            [
                                'link' => '#',
                                'thumb' =>'assets/images/play-store-icon.png',
                            ],
                        ],
                        'banner_thumb' => 'assets/images/banner/banner-thumb.png',

                    ])
                ]);
            }
            elseif($setting->value === 'choose_section'){
                WebSetting::create([
                    'key' => $setting->value,
                    'value' => json_encode([
                        'choose_thumb' => 'assets/images/choose/choose-thumb.jpg',
                        'title' => 'Built for <br /> Seamless Journeys',
                        'description' => 'Customers can utilize the customer app to conveniently browse products, make purchases, track orders, and stay updated s, experience and fostering brand loyalty.',
                        'list_item' => [
                            [
                                'name' => 'Live Ride Tracking',
                                'thumb' =>'assets/images/choose/choose-icon-01.png',
                            ],
                            [
                                'name' => 'Multiple Ride Options',
                                'thumb' =>'assets/images/choose/Multiple-Ride-Options.png',
                            ],
                            [
                                'name' => 'Cashless Payments',
                                'thumb' =>'assets/images/choose/Cashless-Payments.png',
                            ],
                            [
                                'name' => 'Instant Notifications',
                                'thumb' =>'assets/images/choose/Instant-Notifications.png',
                            ],
                            [
                                'name' => 'Ratings & Feedback',
                                'thumb' =>'assets/images/choose/Ratings-&-Feedback.png',
                            ],
                            [
                                'name' => 'Smart Ride Matching',
                                'thumb' =>'assets/images/choose/Smart-Ride-Matching.png',
                            ],
                            [
                                'name' => 'In App Chatting',
                                'thumb' =>'assets/images/choose/In-App-Chatting.png',
                            ],
                            [
                                'name' => 'Ride History & Receipts',
                                'thumb' =>'assets/images/choose/Ride-History-&-Receipts.png',
                            ],
                        ],
                    ])
                ]);
            }
            elseif($setting->value === 'app_section'){
                WebSetting::create([
                    'key' => $setting->value,
                    'value' => json_encode([
                        'background_image' => 'assets/images/apps/apps-banner.jpg',
                        'title' => ' Move Smarter <br /> With Our Ride App',
                        'description' => 'Take control of your travel with flexible ride options, real-time tracking, and simple payments — all in one app.',
                        'app_store' => [
                            [
                                'link' => '#',
                                'thumb' =>'assets/images/apps/app-store.png',
                            ],
                            [
                                'link' => '#',
                                'thumb' =>'assets/images/apps/play-store.png',
                            ],
                        ],
                        'app_thumb' => 'assets/images/apps/apps-thumb.png',

                    ])
                ]);
            }
            elseif($setting->value === 'feature_section'){
                WebSetting::create([
                    'key' => $setting->value,
                    'value' => json_encode([
                        'background_image' => 'assets/images/feature/feature-bg.png',
                        'title' => ' How Ready To Ride Works',
                        'sub_title' => 'Book, Ride, Arrive!',
                        'description' => 'Our ride-share app makes transportation easy, convenient, and reliable for everyone. Follow these simple steps to get started today!',
                        'feature_card' => [
                            [
                                'number' => 1,
                                'icon_image' =>'assets/images/feature/feature-icon-01.png',
                                'content_title' => 'Download & Install The App',
                                'content_subtitle' => 'Get the app from the App Store or Google Play.',
                            ],
                            [
                                'number' => 2,
                                'icon_image' =>'assets/images/feature/feature-icon-02.png',
                                'content_title' => 'Sign Up or Log In',
                                'content_subtitle' => 'Create your profile or log in to access ride services.',
                            ],
                            [
                                'number' => 3,
                                'icon_image' =>'assets/images/feature/feature-icon-03.png',
                                'content_title' => 'Set Pickup & Drop-off Locations',
                                'content_subtitle' => 'Enter your destination and confirm your pickup point.',
                            ],
                            [
                                'number' => 4,
                                'icon_image' =>'assets/images/feature/feature-icon-04.png',
                                'content_title' => 'Choose Your Ride Option',
                                'content_subtitle' => 'Select from economy, premium, or shared rides based on your needs.',
                            ],
                            [
                                'number' => 5,
                                'icon_image' =>'assets/images/feature/feature-icon-05.png',
                                'content_title' => 'Confirm & Track Your Ride',
                                'content_subtitle' => 'Get matched with a driver, see their details, and track their arrival in real time.',
                            ],
                            [
                                'number' => 6,
                                'icon_image' =>'assets/images/feature/feature-icon-06.png',
                                'content_title' => 'Enjoy a Safe & Comfortable Ride',
                                'content_subtitle' => 'Relax as your driver takes you to your destination.',
                            ],
                        ],
                    ])
                ]);
            }
            elseif($setting->value === 'discover_section'){
                WebSetting::create([
                    'key' => $setting->value,
                    'value' => json_encode([
                        'title' => ' Discover, <br /> Ride & Arrive with Ease!',
                        'description' => 'From quick commutes to premium rides, get everywhere you need to go—safely affordably, and on time. Book, track, and enjoy hassle-free rides with seamless in-app payments.',
                        'discover_thumb' => 'assets/images/discover/discover-thumb.png',
                        'background_image' => 'assets/images/discover/discover-banner.jpg'
                    ])
                ]);
            }
            elseif($setting->value === 'who_we_are'){
                WebSetting::create([
                    'key' => $setting->value,
                    'value' => json_encode([
                        'who' => [
                            [
                                'title_1' => 'Our Story',
                                'description_1' => 'We are a locally rooted mobility solution built to connect people, reduce traffic congestion, and create earning opportunities. Our mission is to redefine transport with innovation, fairness, and convenience.',
                                'thumb_1' =>'assets/images/who-we-are/thumb-01.jpg',
                            ],
                            [
                                'title_2' => 'Who We Are',
                                'description_2' => 'We are a locally rooted mobility solution built to connect people, reduce traffic congestion, and create earning opportunities. Our mission is to redefine transport with innovation, fairness, and convenience.',
                                'thumb_2' =>'assets/images/who-we-are/thumb-01.jpg',
                            ],
                        ],

                    ])
                ]);
            }
            elseif($setting->value === 'register_section'){
                WebSetting::create([
                    'key' => $setting->value,
                    'value' => json_encode([
                        'background_image' => 'assets/images/apps/apps-banner.jpg',
                        'thumb' => 'assets/images/cta/cta-thumb.jpg',
                        'title' => 'REGISTER AS Diver',
                        'sub_title' => 'Join Now',
                        'description' => 'Flexible, robust, and user-friendly—your learning solution for the future',
                        'button' => [
                            [
                                'button_name_1' => 'Register Now',
                                'button_link_1' => '#'
                            ]

                        ]

                    ])
                ]);
            }
            elseif($setting->value === 'testimonial_section'){
                WebSetting::create([
                    'key' => $setting->value,
                    'value' => json_encode([
                       'title' => 'Our User Review',
                       'description' => 'From certified courses to study kits, get everything you need to sharpen your skills and advance your career. Browse, purchase, and start learning instantly with seamless in-app transactions.',
                       'testimonial_content' => [
                            [
                                'title_1' => 'Ralph Edwards',
                                'rating_1' => 5,
                                'avatar_image_1' => 'assets/images/apps/apps-banner.jpg',
                                'date_1' => 01/04/2025,
                                'description_1' => 'We are a locally rooted mobility solution built to connect people, reduce traffic congestion, and create earning opportunities. Our mission is to redefine transport with innovation, fairness, and convenience.',
                            ],
                            [
                                'title_2' => 'Marvin McKinney',
                                'rating_2' => 5,
                                'avatar_image_2' => 'assets/images/testimonial/avatar-02.png',
                                'date_2' => 01/04/2025,
                                'description_2' => 'I am proud to say that a few months after taking this course... I passed my exam and am now an AWS Certified Cloud Practitioner! This content was exactly what was included in the CCP exam.',
                            ],
                            [
                                'title_3' => 'Ralph Edwards',
                                'rating_3' => 5,
                                'avatar_image_3' => 'assets/images/testimonial/avatar-01.png',
                                'date_3' => 01/04/2025,
                                'description_3' => 'I am proud to say that a few months after taking this course... I passed my exam and am now an AWS Certified Cloud Practitioner! This content was exactly what was included in the CCP exam.',
                            ],
                        ],
                    ])
                ]);
            }
            elseif($setting->value === 'accordian_section'){
                WebSetting::create([
                    'key' => $setting->value,
                    'value' => json_encode([
                        'title' => 'Frequently',
                        'sub_title' => 'Asked Questions',
                        'accordian_thumb' => 'assets/images/faq/faq-thumb.png',
                        'accordian_items' => [
                            [
                                'title_1' => 'How do I track my order?',
                                'content_1' => 'Lorem ipsum dolor, sit amet consectetur adipisicing elit. Minima expedita nesciunt explicabo velit sequi facere maiores illo dolores in veritatis doloribus delectus non, amet temporibus, recusandae porro eum ullam possimus.',
                            ],
                            [
                                'title_2' => 'Do you offer international shipping?',
                                'content_2' => 'Lorem ipsum dolor, sit amet consectetur adipisicing elit. Minima expedita nesciunt explicabo velit sequi facere maiores illo dolores in veritatis doloribus delectus non, amet temporibus, recusandae porro eum ullam possimus.',
                            ],
                            [
                                'title_3' => 'How can I contact customer support?',
                                'content_3' => 'Lorem ipsum dolor, sit amet consectetur adipisicing elit. Minima expedita nesciunt explicabo velit sequi facere maiores illo dolores in veritatis doloribus delectus non, amet temporibus, recusandae porro eum ullam possimus.',
                            ],
                            [
                                'title_4' => 'Can I change my order after it has been placed?',
                                'content_4' => 'Lorem ipsum dolor, sit amet consectetur adipisicing elit. Minima expedita nesciunt explicabo velit sequi facere maiores illo dolores in veritatis doloribus delectus non, amet temporibus, recusandae porro eum ullam possimus.',
                            ],

                        ]
                    ])
                ]);
            }
            elseif($setting->value === 'footer'){
                WebSetting::create([
                    'key' => $setting->value,
                    'value' => json_encode([
                        'footer_logo' => 'assets/images/logo/logo-white.svg',
                        'description' => 'Elevate Your Business with Innovative Web, App, and Software Solutions. Partner for Excellence in Tech.',
                        'link' => [
                            [
                                'link_1' => '+8801937203743',
                                'link_icon_1' =>'assets/images/call-icon.png',
                            ],
                            [
                                'link_2' => 'razinsoftltd@gmail.com',
                                'link_icon_2' =>'assets/images/email-icon.png',
                            ],
                        ],
                        'social_icon' => [
                            [
                                'icon_1' => 'assets/images/call-icon.png',
                                'link_icon_1' =>'#',
                            ],
                            [
                                'icon_2' =>'assets/images/email-icon.png',
                                'link_icon_2' =>'##',
                            ],
                             [
                                'icon_3' =>'assets/images/email-icon.png',
                                'link_icon_3' =>'###',
                            ],
                        ],
                        'footer_link' => [
                            [
                                'link_1' => '#',
                                'content_1' => 'About Us',
                            ],
                            [
                                'link_2' => '#',
                                'content_2' => 'Contact Us',
                            ],
                            [
                                'link_3' => '#',
                                'content_3' => 'Terms & Conditions',
                            ],
                            [
                                'link_4' => '#',
                                'content_4' => 'Privacy Policy',
                            ],
                        ],
                        'footer_text' => '2025 Razinsoft All Right Reserved',
                    ])
                ]);
            }

        }

    }
}
