<?php

namespace App\Http\Controllers;

use App\Events\OrderOnlinePayment;
use Illuminate\Http\Request;
use App\Models\Order;
use App\Models\PaymentGateway;
use App\Models\Settings;
use Yabacon\Paystack;
use App\Repositories\TransactionRepository;

class PaymentController extends Controller
{

    public function showCheckout(Request $request)
    {
        return view('checkout', [
            'razorpay_order_id' => $request->query('razorpay_order_id'),
            'order_id' => $request->query('order_id'),
            'key' => $request->query('key'),
            'amount' => $request->query('amount'),
            'currency' => $request->query('currency'),
            'email' => $request->query('email'),
            'name' => $request->query('name'),
        ]);
    }

    public function flutterwaveCheckout(){

        $order = Order::find(request()->query('order'));
         // $paymentGateway = PaymentGateway::where('type', 'flutterwave')->first();
        // $flutterAcc = json_decode($paymentGateway->config);
        $setting = Settings::query()->where('key', 'site_config')->value('value');
        $generalSettings = $setting ? json_decode($setting) : [];

        $send['API_publicKey'] = $flutterAcc->public_key ?? 'FLWPUBK_TEST-0ee1835b2e1088d2a529356ec7dcdb30-X';
        $send['encryption_key'] = $flutterAcc->encryption_key ?? 'FLWSECK_TEST78b28d6fdf42';
        $send['email'] = auth()->user()->email;
        $send['amount'] = round($order->cost_best,2);
        $send['phone'] = auth()->user()->mobile;
        $send['currency'] = $generalSettings->currency;
        $send['txref'] = random_int(1000000000, 9999999999);
            // $send['notify_url'] = url('ipn/flutterwave');

        return view('pay.flutterwave', compact('send'));

    }


    public function successPayment(Request $request)
    {
        $request->validate([
            'order_id' => 'required|exists:orders,id',
        ]);

        $paymentMethod = $request->input('payment');
        $order = Order::find($request->order_id);

        if($paymentMethod == 'stripe'){
            $paymentMethod = PaymentGateway::where('type','stripe')->first();
            $secret_key = json_decode($paymentMethod->config)->secret_key;
            \Stripe\Stripe::setApiKey($secret_key);
            $sessionId = $request->input('session_id');
            $session = \Stripe\Checkout\Session::retrieve($sessionId);
            if ($session->payment_status === 'paid') {
                (new TransactionRepository())->makePayment($order, $paymentMethod);
                event(new OrderOnlinePayment($order, $order->driver->user_id));
            }
            return to_route('payment.success.response');
        }
        elseif($paymentMethod == 'razorpay'){
             $api = new \Razorpay\Api\Api(env('RAZORPAY_KEY_ID'), env('RAZORPAY_KEY_SECRET'));

            try {
                $attributes = [
                    'razorpay_order_id' => $request->razorpay_order_id,
                    'razorpay_payment_id' => $request->razorpay_payment_id,
                    'razorpay_signature' => $request->razorpay_signature
                ];

                $api->utility->verifyPaymentSignature($attributes);

                return to_route('payment.success.response');
            } catch (\Exception $e) {
            }
        }
        elseif($request->payment == 'paystack') {
            $reference = $request->reference;

            $paymentMethod = \App\Models\PaymentGateway::where('type', 'paystack')->first();
            $config = json_decode($paymentMethod->config);
            $secretKey = $config->secret_key ?? null;

            if (!$secretKey) {
                return redirect()->route('payment.cancel')
                    ->with('error', 'Paystack not configured.');
            }

            try {
                $paystack = new Paystack($secretKey);
                $tranx = $paystack->transaction->verify(['reference' => $reference]);

                if ($tranx->data->status === 'success') {
                   (new TransactionRepository())->makePayment($order, $paymentMethod);
                    event(new OrderOnlinePayment($order, $order->driver->user_id));
                }

                 return to_route('payment.success.response');
            } catch (\Exception $e) {
                return redirect()->route('payment.cancel')
                    ->with('error', $e->getMessage());
            }
        }
        return $this->json('Payment was completed successfully');
    }

    public function success()
    {
        return $this->json('Payment done successfully.');
    }

    public function cancelPayment()
    {
        return $this->json('Payment not completed.');
    }
}
